unit MinMax;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm4 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    nev: TEdit;
    Label2: TLabel;
    tankor: TEdit;
    kreditpont: TEdit;
    ListBox1: TListBox;
    MinKredit: TButton;
    MaxKredit: TButton;
    Bezar: TButton;
    Label4: TLabel;
    procedure MinKreditClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure MaxKreditClick(Sender: TObject);
    procedure BezarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form4: TForm4;

implementation
uses DiakAdat;
{$R *.DFM}

procedure TForm4.MinKreditClick(Sender: TObject);
var
    min: integer;
    d  : TDiak;
begin
   ListBox1.Clear;
   nev.Clear;
   tankor.Clear;
   kreditpont.Clear;
   if Assigned(Evf.elso) then
    begin
      min:=Evf.MinKreditpont;
      d := Evf.elso;
      while d <> nil do
      begin
        if d.kreditpont = min then
           ListBox1.ITems.Add(d.nev);
        d:= d.kovetkezo;
      end;
      kreditpont.Text := IntToStr(min);
      Label4.Caption := 'Minimlis kreditpont';
    end;
end;

procedure TForm4.ListBox1Click(Sender: TObject);
var
   p:TDiak;
begin
   If ListBox1.ItemIndex>=0 then
     begin
       p:= Evf.elso;
       while p <> nil do
       begin
         if ListBox1.Items[ListBox1.ItemIndex]= p.nev then
           begin
                nev.Text := ListBox1.Items[ListBox1.ItemIndex];
                tankor.Text := IntToStr(p.tankor);
                kreditpont.Text := IntToStr(p.kreditpont);
                break;
           end;
           p:= p.kovetkezo;
        end;
     end;
end;

procedure TForm4.MaxKreditClick(Sender: TObject);
var
    max: integer;
    d  : TDiak;
begin
   ListBox1.Clear;
   nev.Clear;
   tankor.Clear;
   kreditpont.Clear;
   if Assigned(Evf.elso) then
    begin
     d := Evf.elso;
     max:=Evf.MaxKreditpont;
     while d <> nil do
      begin
        if d.kreditpont = max then
           ListBox1.ITems.Add(d.nev);
        d:= d.kovetkezo;
      end;
      kreditpont.Text := IntToStr(max);
      Label4.Caption := 'Maximlis kreditpont';
    end;
end;

procedure TForm4.BezarClick(Sender: TObject);
begin
   Close;
end;

end.
